<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\UserRoleController;
use App\Http\Controllers\TestController;
use App\Http\Controllers\UserPermissionController;
use App\Http\Controllers\ClientUserController;
use App\Http\Controllers\ChipsDepositController;
use App\Http\Controllers\AccountStatementaController;
use App\Http\Controllers\CreateMatchController;
use App\Http\Controllers\EmergencyMatchController;
use App\Http\Controllers\ManualMatchController;
use App\Http\Controllers\ViewMatchController;
use App\Http\Controllers\MatchTossController;
use App\Http\Controllers\FancyresultController;
use App\Http\Controllers\HomeController;

use App\Http\Controllers\ClientLoginController;
use App\Http\Controllers\ClientRegistrationController; 
use App\Http\Controllers\ClientDashboardController; 
use App\Http\Controllers\CricketPageClientController; 
use App\Http\Controllers\BetController; 
use App\Http\Controllers\AnnouncementController; 
use App\Http\Controllers\ChipsSummeryController; 
use App\Http\Controllers\ChipsStatementController; 
use App\Http\Controllers\ProfitLossReportController;
use App\Http\Controllers\LiveScoreController; 
use App\Http\Controllers\UserIdController; 
use App\Http\Controllers\FrontClientProfitLossController;
use App\Http\Controllers\FrontWithdrawlController; 
; 


  




/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });


//login Controller

// Route::get('/admin', [LoginController::class, 'login'])->name('login');
// Route::get('/admin/logout', [LoginController::class, 'logout'])->name('logout');
// Route::post('/authenticate', [LoginController::class, 'index'])->name('authenticate');

// //Dashboard URL
// Route::get('admin/dashboard', [DashboardController::class, 'index'])->name('dashboard');

Route::get('/get_cricket_list', [ClientDashboardController::class, 'get_cricket_list'])->name('get_cricket_list'); 
Route::get('/get_soccer_list', [ClientDashboardController::class, 'get_soccer_list'])->name('get_soccer_list'); 
Route::get('/get_tennis_list', [ClientDashboardController::class, 'get_tennis_list'])->name('get_tennis_list'); 
Route::get('/last_admin_amount/{chips}', [UserController::class, 'last_admin_amount'])->name('last_admin_amount');

Route::get('/frontclientprofitlossreport/{fromdate}/{todate}', [FrontClientProfitLossController::class, 'frontclientprofitlossreport'])->name('frontclientprofitlossreport');     
Route::get('/bet_history_list/{fromdate}/{todate}', [FrontClientProfitLossController::class, 'bet_history_list'])->name('bet_history_list');     


Route::get('/get_chip_summery_list/{client}/{match}/{fdate}/{tdate}', [ChipsSummeryController::class, 'get_chip_summery_list'])->name('get_chip_summery_list');  
Route::get('/get_filter_acst_list/{st}/{mt}/{fd}/{td}', [AccountStatementaController::class, 'get_filter_acst_list'])->name('get_filter_acst_list');   
Route::get('/get_profit_loss_list/{client}/{fromdate}/{todate}', [ProfitLossReportController::class, 'get_profit_loss_list'])->name('get_profit_loss_list');  


Route::post('/bet_saved', [BetController::class, 'bet_save'])->name('bet_saved');
Route::post('/bet_saved_soccer', [BetController::class, 'bet_saved_soccer'])->name('bet_saved_soccer');
Route::post('/bet_saved_tennis', [BetController::class, 'bet_saved_tennis'])->name('bet_saved_tennis');

Route::get('/get_team_cl/{chips}', [CricketPageClientController::class, 'get_team_cl'])->name('get_team_clget_team_cl');  
Route::get('/get_list_by_selection/{id}', [EmergencyMatchController::class, 'get_list_by_selection'])->name('get_list_by_selection');   
Route::get('/get_league', [EmergencyMatchController::class, 'get_league'])->name('get_league');   
Route::get('/list_by_radio_selection/{l}', [ViewMatchController::class, 'list_by_radio_selection'])->name('list_by_radio_selection');   
Route::get('/default_list_in_view_match/{level}/{status}', [ViewMatchController::class, 'default_list_in_view_match'])->name('default_list_in_view_match');   


  


Route::get('/match_toss_open/{id}', [MatchTossController::class, 'match_toss_open'])->name('match_toss_open');   
Route::get('/get_team_transtoss/{chips}', [MatchTossController::class, 'get_team_transtoss'])->name('get_team_transtoss');
Route::get('/view_cricket_filter/{l}', [ViewMatchController::class, 'cricket_filter'])->name('view_cricket_filter');   
Route::get('/user_permission_get_submenu/{id}/{role}', [UserPermissionController::class, 'get_submenu'])->name('get_submenu');
Route::get('/last_amount/{chips}', [ChipsDepositController::class, 'last_amount'])->name('last_amount');


Route::prefix('admin')->group(function (){
    Route::get('/', [LoginController::class, 'login'])->name('login');
    Route::get('/logout', [LoginController::class, 'logout'])->name('logout');
    Route::post('/authenticate', [LoginController::class, 'index'])->name('authenticate'); 
    
    //Dashboard URL
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard'); 

//User URL
Route::get('/user_list', [UserController::class, 'list'])->name('user_list');  
Route::get('/add_user', [UserController::class, 'add'])->name('add_user');  
Route::get('/del/{id}', [UserController::class, 'delete'])->name('del');  
Route::post('/user_save', [UserController::class, 'save'])->name('user_save');  
Route::get('/add_user/{id}', [UserController::class, 'edit'])->name('edit');  
Route::post('/admin_chips_amount_store', [UserController::class, 'admin_chips_amount_store'])->name('admin_chips_amount_store');
Route::get('/withdrawl_admin', [UserController::class, 'withdrawl_admin'])->name('withdrawl_admin');  
Route::post('/confirm_admin_withdrawl', [UserController::class, 'confirm_admin_withdrawl'])->name('confirm_admin_withdrawl');


Route::get('/default_list_in_view_match/{level}/{status}', [ViewMatchController::class, 'default_list_in_view_match'])->name('default_list_in_view_match');   



Route::get('/user_list_id/{id}', [UserIdController::class, 'add_user_id'])->name('user_list_id');  
Route::post('/add_user_id', [UserIdController::class, 'add'])->name('add_user_id');  
Route::post('/save_mini_admin', [UserIdController::class, 'save_mini_admin'])->name('save_mini_admin');  
Route::get('/super_master_popup/{id}', [UserIdController::class, 'super_master_popup'])->name('super_master_popup');  
Route::post('/save_smda', [UserIdController::class, 'save_smda'])->name('save_smda');  
Route::get('/smda_popup/{id}', [UserIdController::class, 'smda_popup'])->name('smda_popup'); 
Route::post('/save_master', [UserIdController::class, 'save_master'])->name('save_master');  
Route::get('/master_popup/{id}', [UserIdController::class, 'master_popup'])->name('master_popup'); 
Route::post('/save_dealer', [UserIdController::class, 'save_dealer'])->name('save_dealer');  

Route::get('/add_user_popup/{id}', [UserIdController::class, 'add_user_popup'])->name('add_user_popup');   
Route::post('/save_client_by_dealer', [UserIdController::class, 'save_client_by_dealer'])->name('save_client_by_dealer');  








 
//User Role
Route::get('/user_role_list', [UserRoleController::class, 'list'])->name('user_role_list');   
  
Route::get('/add_user_role', [UserRoleController::class, 'add'])->name('add_user_role');  
Route::post('/user_role_save', [UserRoleController::class, 'save'])->name('user_role_save');
Route::get('/del_role/{id}', [UserRoleController::class, 'delete'])->name('del_role');   
Route::get('/add_user_role/{id}', [UserRoleController::class, 'edit'])->name('user_role_edit');   


//test
/* Route::get('/header_test', [TestController::class, 'header_test'])->name('header_test'); 
Route::get('/nav_test', [TestController::class, 'nav_test'])->name('nav_test'); 
Route::get('/test_all', [TestController::class, 'test_all'])->name('test_all'); 
Route::get('/footer_test', [TestController::class, 'footer_test'])->name('footer_test'); 
 */
//User Permission
Route::get('/user_permission', [UserPermissionController::class, 'add'])->name('user_permission');
// Route::get('/user_permission_get_submenu/{id}/{role}', [UserPermissionController::class, 'get_submenu'])->name('get_submenu');
Route::post('/user_permission_store', [UserPermissionController::class, 'save'])->name('user_permission_store'); 
 
//Client User
Route::get('/client_list', [ClientUserController::class, 'list'])->name('client_list');  
Route::get('/add_client', [ClientUserController::class, 'add'])->name('add_client');   
Route::get('/add_client/{id}', [ClientUserController::class, 'edit'])->name('edit_client');   
Route::get('/del_client/{id}', [ClientUserController::class, 'del'])->name('del_client');    
Route::post('/client_save', [ClientUserController::class, 'save'])->name('client_save'); 

// client deposit
//Route::get('/add_chips/{id}', [ChipsDepositController::class, 'deposit_list'])->name('add_chips');
Route::post('/save_chips_amount', [ChipsDepositController::class, 'save_chips'])->name('save_chips_amount');
// Route::get('/last_amount/{chips}', [ChipsDepositController::class, 'last_amount'])->name('last_amount');    
 


//Match 
Route::get('/create_match', [CreateMatchController::class, 'list'])->name('create_match'); 
// Route::get('/add_match', [CreateMatchController::class, 'add'])->name('add_match'); 
Route::post('/match_store', [CreateMatchController::class, 'save'])->name('match_store'); 
Route::post('/soc_match_store', [CreateMatchController::class, 'saveSoccer'])->name('soc_match_store');  
Route::post('/tenn_match_store', [CreateMatchController::class, 'saveTennis'])->name('tenn_match_store');  



// Route::get('/get_cricket_list/{c}', [CreateMatchController::class, 'get_cricket_list'])->name('get_cricket_list'); 



// Emergency Match
Route::get('/emergency_match', [EmergencyMatchController::class, 'list'])->name('emergency_match');   
Route::post('/emergency_match_store', [EmergencyMatchController::class, 'save'])->name('emergency_match_store'); 
// Route::get('/emergency_match', [EmergencyMatchController::class, 'soccer_list'])->name('emergency_match');

//Manual Match
Route::get('/create_manual_match', [ManualMatchController::class, 'list'])->name('create_manual_match');   
Route::get('/add_manual_match', [ManualMatchController::class, 'add'])->name('add_manual_match');  
Route::post('/store_manual_match', [ManualMatchController::class, 'save'])->name('store_manual_match'); 
Route::get('/manual_m_del/{id}', [ManualMatchController::class, 'del'])->name('manual_m_del'); 
Route::get('/add_manual_match/{id}', [ManualMatchController::class, 'edit'])->name('edit_manual_match'); 
 

//View match 
Route::get('/view_match', [ViewMatchController::class, 'list'])->name('view_match'); 
Route::get('/delete_match_view/{id}', [ViewMatchController::class, 'del'])->name('delete_match_view');  




//match  Toss
Route::get('/match_toss', [MatchTossController::class, 'list'])->name('match_toss');  
Route::get('/delete_match_toss/{id}', [MatchTossController::class, 'del_toss'])->name('delete_match_toss');  
Route::get('/coin_transfer_form/{id}', [MatchTossController::class, 'coin_tran_form'])->name('coin_transfer_form');  
Route::get('/match_toss_open/{id}', [MatchTossController::class, 'match_toss_open'])->name('match_toss_open');  
Route::get('/match_toss_close/{id}', [MatchTossController::class, 'match_toss_close'])->name('match_toss_close');   
Route::post('/declare_winner', [MatchTossController::class, 'declare_winner'])->name('declare_winner');
 

//match  Toss
Route::get('/fancy_result', [FancyresultController::class, 'list'])->name('fancy_result'); 

//News And Announcement 
route::get('/announcement_list',[AnnouncementController::class, 'index'])->name('announcement_list');
route::get('/add_news',[AnnouncementController::class, 'add'])->name('add_news');
route::post('/store_news',[AnnouncementController::class, 'save'])->name('store_news');
Route::get('/delete/{id}', [AnnouncementController::class, 'delete'])->name('delete_news');  


// REPORT
// Account Statement
Route::get('/account_statement', [AccountStatementaController::class, 'accountstatement'])->name('accountstatement');    
Route::get('/get_filter_acst_list/{st}/{mt}/{fd}/{td}', [AccountStatementaController::class, 'get_filter_acst_list'])->name('get_filter_acst_list');  
Route::post('/ac_statement_export',[AccountStatementaController::class, 'ac_statement_export'])->name('ac_statement_export');  
 
// Chips summery

Route::get('/chips_summery', [ChipsSummeryController::class, 'chips_summery'])->name('chips_summery');    
Route::get('/get_chip_summery_list/{client}/{match}/{fdate}/{tdate}', [ChipsSummeryController::class, 'get_chip_summery_list'])->name('get_chip_summery_list');  
Route::post('/chips_summery_export', [ChipsSummeryController::class, 'chips_summery_export'])->name('chips_summery_export');  


// chips statement
Route::get('/chips_statement', [ChipsStatementController::class, 'chips_statement'])->name('chips_statement');   

//profit and loss
Route::get('/profit_loss', [ProfitLossReportController::class, 'profit_loss'])->name('profit_loss');  
Route::get('/get_profit_loss_list/{client}', [ProfitLossReportController::class, 'get_profit_loss_list'])->name('get_profit_loss_list');  
Route::get('/p_l_list', [ProfitLossReportController::class, 'profit_loss'])->name('p_l_list');  
Route::post('/admin_profit_loss_client', [ProfitLossReportController::class, 'profitlossexport'])->name('admin_profit_loss_client');     
 
 
});        



Route::prefix('client')->group(function (){

//for Client Home Page
// Route::get('/fancy_result', [HomeController::class, 'list'])->name('fancy_result');    
Route::get('/', [HomeController::class, 'homepage'])->name('homepage');
Route::get('/client_login', [ClientLoginController::class, 'login'])->name('client_login');
Route::post('/client_authenticate', [ClientLoginController::class, 'index'])->name('client_authenticate');
Route::get('/logout', [ClientLoginController::class, 'logout'])->name('logout');
 
Route::get('/client_registration', [ClientRegistrationController::class, 'registration'])->name('client_registration'); 
Route::post('/store_client', [ClientRegistrationController::class, 'save'])->name('store_client'); 

//Client Dashboard URL
Route::get('/client_dashboard', [ClientDashboardController::class, 'client_dashboard'])->name('client_dashboard'); 
Route::get('/client_dashboardtoday', [ClientDashboardController::class, 'client_dashboardtoday'])->name('client_dashboardtoday'); 

Route::get('/get_cricket_list', [ClientDashboardController::class, 'get_cricket_list'])->name('get_cricket_list'); 
Route::get('/get_soccer_list', [ClientDashboardController::class, 'get_soccer_list'])->name('get_soccer_list'); 
Route::get('/get_tennis_list', [ClientDashboardController::class, 'get_tennis_list'])->name('get_tennis_list'); 





//for cricket page (client side)
Route::get('/bet_cricket/{id}', [CricketPageClientController::class, 'index'])->name('bet_cricket'); 
Route::get('/bet_soccer/{id}', [CricketPageClientController::class, 'soccer_index'])->name('bet_soccer'); 
Route::get('/bet_tennis/{id}', [CricketPageClientController::class, 'tennis_index'])->name('bet_tennis');  

Route::post('/bet_saved', [BetController::class, 'bet_save'])->name('bet_saved');
Route::post('/bet_saved_soccer', [BetController::class, 'bet_saved_soccer'])->name('bet_saved_soccer');
Route::post('/bet_saved_tennis', [BetController::class, 'bet_saved_tennis'])->name('bet_saved_tennis');
 

//Live Score
Route::get('/live_Score', [LiveScoreController::class, 'live_Score'])->name('live_Score');    


// Profit and Loss    
Route::get('/client_profitloss_page', [FrontClientProfitLossController::class, 'index'])->name('client_profitloss_page');     
Route::post('/client_profit_loss_export_rep', [FrontClientProfitLossController::class, 'frontclientprofitlossexport'])->name('client_profit_loss_export_rep');    
Route::get('/get_game_list/{id}', [FrontClientProfitLossController::class, 'get_game_list'])->name('get_game_list');     
Route::get('/profit_loss_from_statement/{id}', [FrontClientProfitLossController::class, 'profit_loss_from_statement'])->name('profit_loss_from_statement');     

 
Route::get('/bet_view/{id}', [FrontClientProfitLossController::class, 'get_bet_view'])->name('bet_view');   
Route::get('/client_accountstatement_page', [FrontClientProfitLossController::class, 'client_accountstatement_page'])->name('client_accountstatement_page');
Route::get('/bet_history', [FrontClientProfitLossController::class, 'bet_history'])->name('bet_history');     

Route::get('/withdrawl_page_client/{id}', [FrontWithdrawlController::class, 'withdrawl_page_client'])->name('withdrawl_page_client');   
Route::post('/amount_withdrawl_client',[FrontWithdrawlController::class, 'amount_withdrawl_client'])->name('amount_withdrawl_client');  



 // data clustor
  
});