<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserModelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_user', function (Blueprint $table) {
            $table->id();

            $table->integer('company_id');
			
			$table->integer('region');
			$table->integer('sub_region');
			$table->integer('warehouse');
			
			$table->integer('user_role');
			$table->string('user_code',30);
			
			$table->string('first_name',50);
			$table->string('last_name',50);
			
			$table->string('user_name',50);
			$table->string('user_password',100);
			$table->text('address');
			$table->string('city',50);
			
			$table->string('zip',50);
			$table->string('email',50);
			$table->date('user_dob');
			$table->string('user_country',50);
			$table->bigInteger('contact_no');
			$table->string('user_profile_pic',2500)->nullable();
			$table->integer('company_name');
			//$table->string('block_check',30);
			$table->string('block_to',30);
			$table->string('block_from',30);
			$table->integer('created_user')->length(11)->nullable();
			$table->integer('updated_user')->length(11)->nullable();
	        $table->enum('status', ['active', 'inactive']); 

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_user');
    }
}
