<?php

namespace App\Http\Controllers;
 
use App\Models\UserRoleModel;
use Session; 
use App\Models\ManageCodeModel;
use Illuminate\Support\Facades\DB;

use Illuminate\Http\Request;

class UserRoleController extends Controller
{
    //
	 public function list()
    {	
      $get_data = UserRoleModel::all()->sortByDesc('id');
		
      return view('Admin.User.user_role_list',compact('get_data')); 
		
     }
	 public function add(){
		    $result =UserRoleModel::get()->sortByDesc('id')->first();
	   if($result=='')
		 {
			$getcode = ManageCodeModel::where('id', 1)->first();
			$last_code = $getcode->role_code;
		 }
	   else
		 {
			 $getcode = $result->role_code; 
			 $last_code = ++$getcode;
		 } 
		 return view('Admin.User.user_role',compact('last_code'));  
	 }
	 public function save(Request $request)
     {	
	    $data=new UserRoleModel;			
		if($request->updated_id) 
		  {
					
			 $data = UserRoleModel::find($request->updated_id);
			 $data->role_code=$request->role_code;
			 $data->role_name=$request->role_name;
			 $data->updated_user= Session::get('user_id');
			 $data->status=$request->status;
			 $data->save();
			 return redirect(route('user_role_list'))->with('successMessage','User Role Updated Successfully');
		
		  } else 
		     {
					
				$data->role_code=$request->role_code;
				$data->role_name=$request->role_name;
				$data->created_user= Session::get('user_id');
				$data->status=$request->status;
				$data->save();
				return redirect(route('user_role_list'))->with('successMessage','User Role Added Successfully');
				
			  }	 
     }
	 
	 public function edit($id)
    {   
	  $get_data=UserRoleModel::find($id); 
	    return view('Admin.User.user_role',compact('get_data')); 
    }
	 
	 
	 
	 public function delete($id){
		 $del= UserRoleModel::find($id)->delete(); 
		 return redirect(route('user_role_list'))->with('successMessage','User Role Deleted Successfully');
	} 
	 
}
