<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class ProfitLossExports implements FromView,ShouldAutoSize
{
    protected $fromdate1;
	protected $todate1;
	protected $clients1; 
  
    /**
    * @return \Illuminate\Support\Collection
    */
      
    function __construct($fromdate1,$todate1,$clients1) {
        $this->fromdate = $fromdate1;
        $this->todate = $todate1;
        $this->clients1 = $clients1; 
    }
    public function view(): View
    {
        $login_data = session()->all();  
		$login_user = DB::table('tbl_user')->select('tbl_user.*')->where('id',$login_data["user_id"])->get();
		$id = $login_user[0]->id ;  
		$share = $login_user[0]->admin_share ;    
		$data = DB::table('tbl_chips_transaction_histories')
		->leftjoin('tbl_client_user','tbl_chips_transaction_histories.client_id','=','tbl_client_user.id')
		->leftjoin('tbl_cricket','tbl_chips_transaction_histories.game_id','=','tbl_cricket.id') 
		->select('tbl_chips_transaction_histories.*','tbl_client_user.client_user_name','tbl_cricket.matchName')
		->whereIn('tbl_chips_transaction_histories.client_id',explode(",",$this->clients1))
		->whereDate('tbl_chips_transaction_histories.created_at','>=',$this->fromdate)
		->whereDate('tbl_chips_transaction_histories.created_at','<=',$this->todate)  
		->whereIn('tbl_chips_transaction_histories.by_who', [ 2, 3]) 
		->get() ;   
//   dd($data);
        return view('export.report.profit_loss_export',compact('data'));		

    }
}
