<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class FrontClientProfitLossExport implements FromView,ShouldAutoSize
{
    protected $fromdate1;
	protected $todate1;
	// protected $clients1; 
  
    /**
    * @return \Illuminate\Support\Collection
    */
      
    function __construct($fromdate1,$todate1) {
        $this->fromdate = $fromdate1;
        $this->todate = $todate1; 
    }
    public function view(): View
    {
        $login_data = session()->all();  
		$login_user = DB::table('tbl_client_user')->select('tbl_client_user.*')->where('id',$login_data["user_id"])->get(); 
		$id = $login_user[0]->id ;   

		$data = DB::table('tbl_front_client_profit_loss')
		->leftjoin('tbl_client_user','tbl_front_client_profit_loss.client_id','=','tbl_client_user.id')
		->leftjoin('tbl_cricket','tbl_front_client_profit_loss.game_id','=','tbl_cricket.game_id') 
		->select('tbl_front_client_profit_loss.*','tbl_client_user.client_user_name','tbl_cricket.matchName')
		->where('tbl_front_client_profit_loss.client_id', $id) 
		->whereDate('tbl_front_client_profit_loss.created_at','>=',$this->fromdate)
		->whereDate('tbl_front_client_profit_loss.created_at','<=',$this->todate)  
		->whereIn('tbl_front_client_profit_loss.by_who', [ 1, 2]) 
		->get() ;   
 
        return view('export.report.front_client_profit_loss_export',compact('data'));		

    }
}
